<?php
// WooCommerce

// Add popup buttons after short description on single product page
add_filter( 'woocommerce_short_description', 'add_pop_up_buttons_after_excerpt_single_product', 20, 1 );
function add_pop_up_buttons_after_excerpt_single_product( $post_excerpt ) {
    if ( have_rows( 'pop_up_buttons' ) && is_single() ):
        $pop_up_buttons = '<div class="wp-block-columns pop-up-buttons">';
        $pop_up_fancyboxes = '';
        $pop_up_buttons_count = count( get_field( 'pop_up_buttons' ) );
        if ( $pop_up_buttons_count == 4) {
            $pop_up_buttons_count = 2;
        }
        while ( have_rows( 'pop_up_buttons' ) ) : the_row();
            $button_text = get_sub_field( 'button_text' );
            $pop_up = get_sub_field( 'pop_up' );
            if ( $pop_up ) {
                $pop_up_ID = $pop_up->ID;
            } else {
                $pop_up_ID = get_sub_field( 'pop_up_id' );
            }
            if ( $pop_up_ID ) {
                $pop_up_buttons .= '<div class="wp-block-column">';
                    $pop_up_buttons .= '<div class="wp-block-buttons">
                        <div class="wp-block-button has-custom-width wp-block-button__width-100 is-style-outline">
                            <a href="#fancyboxID-' . $pop_up_ID . '" class="wp-block-button__link fancybox-inline" data-pop-up-id="' . $pop_up_ID . '">' . $button_text . '</a>
                        </div>
                    </div>';
                $pop_up_buttons .= '</div><!-- /.wp-block-column -->';
                // $pop_up_content = get_the_content( null, false, $pop_up_ID );
                $pop_up_content = do_shortcode( get_the_content( null, false, $pop_up_ID ) ); // Visual Composer made me do it.
                $pop_up_fancyboxes .= '<div style="display:none" class="fancybox-hidden">
                    <div id="fancyboxID-' . $pop_up_ID . '" class="hentry fancybox-inner-content">
                        ' . $pop_up_content . '
                    </div>
                </div>';
                //echo $pop_up_content;
            }
        endwhile;
        $pop_up_buttons .= '</div><!-- /.wp-block-columns -->';
        $post_excerpt = $post_excerpt . "\n" . $pop_up_buttons . "\n" . $pop_up_fancyboxes;
        //$pop_up_buttons_shortcode = do_shortcode( $pop_up_buttons . $pop_up_containers );
        //return $post_excerpt . do_shortcode( $pop_up_buttons_shortcode );
    endif;
    return $post_excerpt;
}

// Make sure the pop up buttons don't appear in the variations description
add_filter( 'woocommerce_available_variation', 'dont_add_pop_up_buttons_to_variations', 10, 3);
function dont_add_pop_up_buttons_to_variations( $data, $product, $variation ) {
    $data['variation_description'] = wpautop( get_post_meta($variation->get_id(), '_variation_description', true) );
    return $data;
}

/* Change home URL in WooCommerce breadcrumb */
add_filter( 'woocommerce_breadcrumb_home_url', 'babaa_woo_custom_breadrumb_home_url' );
function babaa_woo_custom_breadrumb_home_url() {
    if ( get_theme_mod( 'home_page_for_shop_link' ) ) {
        $home_page_for_shop_link = get_permalink( get_theme_mod( 'home_page_for_shop_link' ) );
    } else {
        $home_page_for_shop_link = home_url();
    }
	return $home_page_for_shop_link;
}

/* Rename shop link text in WooCommerce breadcrumb */
add_filter( 'woocommerce_get_breadcrumb', 'babaa_custom_get_breadcrumb', 20, 2 );
function babaa_custom_get_breadcrumb( $crumbs, $breadcrumb ){
    $target = 'shop';
    foreach($crumbs as $key => $crumb){
        if( $target === strtolower( $crumb[0] ) ){
            $crumbs[$key][0] = __( 'all items', 'bsc' );
        }
    }
    $target = 'home';
    foreach($crumbs as $key => $crumb){
        if( $target === strtolower ( $crumb[0] ) ){
            $crumbs[$key][0] = __( 'shop', 'bsc' );
        }
    }
    return $crumbs;
}

/* Replace the strings */
if ( !is_admin() ) {
    function woocommerce_texts( $translated ) {
        $text = array( 
            'Search products...' => 'Search items...', 
            'Search products…' => 'Search items…', 
            'Search products' => 'Search items', 
            'Search products&hellip;' => 'Search items&hellip;', 
            'Have a coupon?' => 'Have a coupon or store credit?', 
        );
        $translated = str_ireplace( array_keys( $text ), $text, $translated );
        return $translated;
    }
    add_filter( 'gettext', 'woocommerce_texts', 20 );
}
