<?php
add_action( 'admin_menu', 'register_babaa_recache_all_products_submenu_page', 99 );
function register_babaa_recache_all_products_submenu_page() {
	add_submenu_page( 'woocommerce', __( 'Recache all products', 'bsc' ), __( 'Recache all products', 'bsc' ), 'manage_options', 'babaa-recache-all-products', 'babaa_recache_all_products' );
}
function babaa_recache_all_products() {
	$canChangeAll = false;
	global $current_user;
    wp_get_current_user();
	if ( is_array( $current_user->roles ) ) {
		$user_roles = $current_user->roles;
		$user_role = array_shift( $user_roles );
		if ( $user_role == 'administrator' ) {
			$canChangeAll = true;
		}
	}
	echo '<div class="wrap">';
	echo '<h2 class="wp-heading-inline">' . __( 'Recache all products', 'bsc' ) . '</h2>
	<hr class="wp-header-end">';
	if ( $canChangeAll ) {
		?>
		<style type="text/css">
			.woocommerce_page_babaa-recache-all-products .wrap iframe {
				width: 100%;
				height: 600px;
				background-color: #fff; 
				display: none;
				margin-bottom: 20px;
			}
			.woocommerce_page_babaa-recache-all-products .wrap .form-table {
				max-width: 600px;
			}
		</style>
		<?php
		echo '<form method="post">';
			if ( isset( $_POST['babaa-recache-all-products-offset'] ) ) {
				$start = intval( $_POST['babaa-recache-all-products-offset'] ) - 1;
			} else {
				$start = 0;
			}
			if ( isset( $_POST['babaa-recache-all-products-last'] ) ) {
				$last = intval( $_POST['babaa-recache-all-products-last'] );
				$posts_per_page = $last - $start;
			} else {
				$posts_per_page = -1;
			}
			$args = array(
				'post_type' => 'product', 
				'post_status' => 'publish', 
				'posts_per_page' => $posts_per_page,
				'offset' => $start
			);
			$query = new WP_Query($args);
			$post_count = $query->post_count;
			$found_posts = $query->found_posts;
			$timeout_multiply = 2;
			$time = gmdate("H:i:s", $post_count * $timeout_multiply);
			if ( $start == 0 ) {
				$start_form = 1;
			} else {
				$start_form = $start + 1;
			}
			if ( $last ) {
				$last_form = $last;
			} else {
				$last_form = $found_posts;
			}
			echo '<p>';
				printf( __( 'Click the Recache-button. It will take %s to recache all %s products, so be patient.', 'bsc' ), $time, $post_count );
				echo '<br>';
				_e( 'Also, you will be logged out. <strong>Don\'t refresh</strong>, just sit back and watch the magic.', 'bsc' );
				echo '<br>';
				printf( __( 'If you get the Maintenance window below when running the recache, add your IP <a href="%s">here</a> and try again.', 'bsc' ), '/wp-admin/admin.php?page=wp-maintenance-settings' );
			echo '</p>
			<p>
				<a href="?page=babaa-recache-all-products&babaa-recache-all-products-urls=show">' . __( 'Show a list of all product URLs', 'babaa' ) . '</a>
			</p>
			<table class="form-table">
				<tr valign="top">
					<th scope="row">Product range</th>
					<td>
						<input name="babaa-recache-all-products-offset" type="number" id="babaa-recache-all-products-offset" value="' . $start_form . '" class="large-text" placeholder="' . esc_attr( __( 'Start with product', 'bsc' ) ) . '" min="1" max="' . $found_posts . '">
						<small>' . esc_attr( __( 'Start with product', 'bsc' ) ) . '</small>
					</td> 
					<td>
						<input name="babaa-recache-all-products-last" type="number" id="babaa-recache-all-products-last" value="' . $last_form . '" class="large-text" placeholder="' . esc_attr( __( 'End with product', 'bsc' ) ) . '" min="1" max="' . $found_posts . '">
						<small>' . esc_attr( __( 'End with product', 'bsc' ) ) . '</small>
					</td> 
				</tr>
			</table>
			<div class="submit">
				<input type="submit" name="babaa-recache-all-products-now" value="' . __( 'Recache', 'bsc' ) . '" class="button-primary" />
			</div>';
			if ( isset( $_POST['babaa-recache-all-products-now'] ) ) {
				if ( $query->have_posts() ) {
					?>
					<script type="text/javascript">
						function recache(timeout, i, last_i, permalink) {
							setTimeout(function () {
								jQuery('#recache-iframe-' + last_i).css('display', 'none');
								jQuery('#recache-iframe-' + i).css('display', 'block');
								jQuery('#recache-iframe-' + i).attr('src', '' + permalink);
								jQuery('.recache-status span').text('' + i + '');
							}, timeout, i, last_i, permalink);
						}
					</script>
					<?php
					$script = '';
					$i = 0;
					echo '<div class="recache-status">Recached <span>0</span> products.</div>';
					echo '<div class="all-status"><span></span></div>';
					echo '<br>';
					echo '<br>';
					// Recache
					echo '<iframe src="" id="recache-iframe-0"></iframe>';
					while ( $query->have_posts() ) : $query->the_post();
						$i++;
						$last_i = $i - 1;
						$timeout = $i * $timeout_multiply;
						echo '<iframe src="" id="recache-iframe-' . $i . '"></iframe>';
						$script .= 'recache(' . $timeout . '000, ' . $i . ', ' . $last_i . ', \'' . get_permalink() . '\');' . "\n";
					endwhile;
					$timeout = $i * $timeout_multiply;
					$script .= 'recache(0, 0, 0, jQuery(\'#wp-admin-bar-logout a\').attr(\'href\'));' . "\n";
					$script .= 'setTimeout(function () {
						jQuery(\'#' . 'recache-iframe-' . $i . '\').css(\'display\', \'none\');' . "\n" . '
						jQuery(\'.' . 'all-status span' . '\').text(\'' . __( 'Done!', 'bsc' ) . '\');' . "\n" . '
					}, ' . $timeout . '000);';
					wp_reset_postdata();
					echo '<script type="text/javascript">' . $script .'</script>';
				}
			}
			if ( isset( $_GET['babaa-recache-all-products-urls'] ) ) {
				if ( $query->have_posts() ) {
					echo '<ol>';
					while ( $query->have_posts() ) : $query->the_post();
						echo '<li>' . get_permalink() . '</li>';
					endwhile;
					echo '</ol>';
				}
			}
		echo '</form>';
	} else {
		_e( 'Only <strong>Administrators</strong> are allowed to run the recache', 'bsc' );
	}
	echo '</div>';
}
