<?php
// Header meta

if ( !is_admin() ) {
    /* Add OG Image */
    add_action ( 'wp_head', 'babaa_og_image_meta', 1 );
    function babaa_og_image_meta() {
        echo '<meta property="og:image" content="' . get_og_image_url() . '"/>' . "\n";
    }
    /* Excerpt as meta description */
    add_action( 'wp_head', 'babaa_meta_description', 1 );
    function babaa_meta_description() {
        //global $post;
        $this_description = '';
        if ( is_single() || is_page() ) {
            while ( have_posts() ) : the_post();
                $this_description = strip_tags( get_the_custom_excerpt() );
            endwhile;
        } elseif ( is_home() ) {
            $this_description = strip_tags( get_the_custom_excerpt( null, get_option( 'page_for_posts' ) ) );
        } elseif ( is_tax() || is_category() || is_tag() ) {
            $term = get_queried_object();
            $this_description = strip_tags( get_the_custom_excerpt( null, null, $term->description ) );
        }
        echo '<meta name="description" content="' . esc_attr( $this_description ) . '"/>' . "\n";
    }
}

/* Return an OG image URL */
function get_og_image_url() {
    $do_fallback_og = false;
    $og_image = null;
    if ( is_home() ) {
        $post_id = get_option( 'page_for_posts' );
    } else {
        $post_id = get_the_ID();
    }
    if ( is_search() ) {
        // Always use fallback OG on blog and search
        $do_fallback_og = true;
    } elseif ( is_archive() ) {
        // Get archive thumbnail as OG
        $current_category_object = get_queried_object();
        $thumbnail_id = get_term_meta( $current_category_object->term_id, 'thumbnail_id', true );
        if ( $thumbnail_id ) {
            $og_image = wp_get_attachment_image_src( $thumbnail_id, 'og_image' )[0];
        } else {
            $do_fallback_og = true;
        }
    } elseif ( get_field( 'og_image', $post_id ) ) {
        // Get specified OG if set
        $og_image = get_field( 'og_image', $post_id );
        $og_image = wp_get_attachment_image_src( $og_image['ID'], 'og_image' )[0];
    } elseif ( get_post_thumbnail_id( $post_id ) ) {
        // Get featured image (or product image) as OG 
        $og_image = wp_get_attachment_image_src( get_post_thumbnail_id( $post_id ), 'og_image' )[0];
    } else {
        // There was no OG, activate fallback
        $do_fallback_og = true;
    }
    if ( $do_fallback_og ) {
        $og_image = get_theme_mod( 'fallback_og_image' );
        if ( $og_image ) {
            $og_image_id = attachment_url_to_postid( $og_image );
            $og_image = wp_get_attachment_image_src( $og_image_id, 'og_image' )[0];
        }
    }
    return $og_image;
}
