<?php
define( 'PREFIX_PLUGIN_VERSION', bsc_get_plugin_version() ); // when new release is read change verion in plugin definition as well as here
define( 'PREFIX_DOMAIN', 'https://plugins-repo.followmedarling.se' ); // replace with your domain, used in  lines 57 and 114
define( 'PREFIX_REPOFOLDER', 'get' ); // replace wiht your folder, used in lines 57 and 114
define( 'PREFIX_SLUG', 'babaa-step-child' );
###############
# Logic
###############

function prefix_add_code_to_the_footer() {

    echo PHP_EOL . '<!-- it_works -->' . PHP_EOL;

}

add_action( 'wp_footer', 'prefix_add_code_to_the_footer' );

###############
# Automatic updates
###############

/*
 * Plugin pop-up when new realase is out
 */

function prefix_plugin_info( $res, $action, $args ) {

    // Do nothing if this is not about getting plugin information
    if ($action !== 'plugin_information') {
        return false;
    }

    // Do nothing if it is not our plugin
    if (PREFIX_SLUG !== $args->slug) {
        return $res;
    }

    if (false == $remote = get_transient( 'prefix_upgrade_' . PREFIX_SLUG )) {

        $remote = wp_remote_get( PREFIX_DOMAIN . '/' . PREFIX_REPOFOLDER . '/?slug=' . PREFIX_SLUG . '&action=info', array(
            'timeout' => 10,
            'headers' => array(
                'Accept' => 'application/json'
            ))
        );

        if (!is_wp_error( $remote ) && isset( $remote[ 'response' ][ 'code' ] ) && $remote[ 'response' ][ 'code' ] == 200 && !empty( $remote[ 'body' ] )) {
            set_transient( 'prefix_upgrade_' . PREFIX_SLUG, $remote, 14400 ); // 4 hours cache
        }
    }

    if (!is_wp_error( $remote )) {

        $remote = json_decode( $remote[ 'body' ] );

        $res = new stdClass();
        $res->name = $remote->name;
        $res->slug = $remote->slug;
        $res->version = $remote->version;
        $res->tested = $remote->tested;
        $res->requires = $remote->requires;
        $res->author = $remote->author;
        $res->author_profile = $remote->author_homepage;
        $res->download_link = $remote->download_link;
        $res->trunk = $remote->download_link;
        $res->last_updated = $remote->last_updated;
        $res->sections = array(
            'description' => $remote->sections->description, // description tab
            'installation' => $remote->sections->installation, // installation tab
        );
        $res->banners = array(
            'low' => $remote->banners->low,
            'high' => $remote->banners->high,
        );

        return $res;
    }

    return false;

}

add_filter( 'plugins_api', 'prefix_plugin_info', 20, 3 );

/**
 * Plugin update
 */
function prefix_push_update( $transient ) {

    if (empty( $transient->checked )) {
        return $transient;
    }

    if (false == $remote = get_transient( 'prefix_upgrade_' . PREFIX_SLUG )) {
        // info.json is the file with the actual plugin information on your server
        $remote = wp_remote_get( PREFIX_DOMAIN . '/' . PREFIX_REPOFOLDER . '/?slug=' . PREFIX_SLUG . '&action=update', array(
            'timeout' => 10,
            'headers' => array(
                'Accept' => 'application/json'
            ))
        );

        if (!is_wp_error( $remote ) && isset( $remote[ 'response' ][ 'code' ] ) && $remote[ 'response' ][ 'code' ] == 200 && !empty( $remote[ 'body' ] )) {
            set_transient( 'prefix_upgrade_' . PREFIX_SLUG, $remote, 21600 ); // 6 hours cache
        }
    }

    if ($remote) {

        $remote = json_decode( $remote[ 'body' ] );

        // your installed plugin version should be on the line below! You can obtain it dynamically of course
        if ($remote && version_compare( PREFIX_PLUGIN_VERSION, $remote->version, '<' ) && version_compare( $remote->requires, get_bloginfo( 'version' ), '<' )) {
            $res = new stdClass();
            $res->slug = PREFIX_SLUG;
            // it could be just mypluginslug1.php if your plugin doesn't have its own directory (my does)
            $res->plugin = PREFIX_SLUG . '/' . PREFIX_SLUG . '.php';
            $res->new_version = $remote->version;
            $res->tested = $remote->tested;
            $res->package = $remote->download_link;
            $transient->response[ $res->plugin ] = $res;
            //$transient->checked[$res->plugin] = $remote->version;
        }
    }
    return $transient;

}

add_filter( 'site_transient_update_plugins', 'prefix_push_update' );

/**
 * Cache the results to make update process fast
 */
function prefix_after_update( $upgrader_object, $options ) {
    if ($options[ 'action' ] == 'update' && $options[ 'type' ] === 'plugin') {
        // just clean the cache when new plugin version is installed
        delete_transient( 'prefix_upgrade_' . PREFIX_SLUG );
    }

}

add_action( 'upgrader_process_complete', 'prefix_after_update', 10, 2 );
