jQuery(document).ready(function() {
    notificationContainerClass();
    linkSelects();
    filterEverythingLinksOnShopHome();
    filterVisibilityOnShopHome();
});
jQuery(window).on("load", function() { 
    popUpSessionStore();
    megaMenuScroll();
    openSubMenuInMobileMenuOnLoad();
});
jQuery(window).scroll(function () {
    closeContainerClass();
});
var resizeTimer;
jQuery(window).resize(function () {
    clearTimeout(resizeTimer);
    resizeTimer = setTimeout(function () {
    	
    }, 500);
});

/* Set class to the notification container since it is not removed and open for animation */
function notificationContainerClass() {
    targetNode = document.querySelector('.gbt-custom-notification-content');
    if ( targetNode !== null) {
        let observer = new MutationObserver(mutationRecords => {
            if (jQuery('.gbt-custom-notification-notice').hasClass('close-notice')) {
                jQuery('.gbt-custom-notification-content').removeClass('open-notice-content');
                jQuery('.gbt-custom-notification-content').addClass('close-notice-content');
                setTimeout(function () {
                    jQuery('#gbt-custom-notification-notice').addClass('hide-notification');
                }, 1000);
            } else {
                jQuery('#gbt-custom-notification-notice').removeClass('hide-notification');
                jQuery('.gbt-custom-notification-content').removeClass('close-notice-content');
                jQuery('.gbt-custom-notification-content').addClass('open-notice-content');
            }
        });
        observer.observe(targetNode, {
            attributes: true,
            childList: true,
            attributeOldValue: true,
            subtree: true,
        });
    }
}

/* Force close the notification, but not on cart page */
function closeContainerClass() {
    if (jQuery('.gbt-custom-notification-notice').hasClass('open-notice') && !jQuery('body').hasClass('woocommerce-checkout') && !jQuery('body').hasClass('woocommerce-cart') && !jQuery('.product').hasClass('product-type-variable')) {
        jQuery('.gbt-custom-notification-notice').removeClass('open-notice');
        jQuery('.gbt-custom-notification-notice').addClass('close-notice');
    }
}

/* Add click to images in fancybox to return to gallery or masonry */
function popUpSessionStore() {
    jQuery('.single-product .wp-block-columns.pop-up-buttons .wp-block-button__link.fancybox-inline').on('click', function() {
        sessionVal = jQuery(this).attr('href');
        sessionStorage.setItem( 'parentModal', sessionVal );
    });
    if (sessionStorage.getItem('parentModal')) {
        jQuery('body').on('click', '#fancybox-wrap #fancybox-outer #fancybox-img', function() {
            parentModal = sessionStorage.getItem('parentModal');
            jQuery('a[href='+parentModal+']').trigger("click");
        });
    }
}

/* Check if an element has scroll */
function hasScrollBar(elem) {
    elemScrollHeight = elem.get(0).scrollHeight;
    elemHeight = elem.outerHeight() + 40; // add padding
    if ( elemScrollHeight > elemHeight ) {
        return true;
    } else {
        return false;
    }
}

/* Check all Menus for scroll */
function megaMenuScroll() {
    jQuery('.show-for-large.main-navigation > ul > li.mega-menu > ul.sub-menu.level-0').each(function() {
        if (hasScrollBar(jQuery(this))) {
            jQuery(this).after('<div class="scroll-icon"> </div>');
            jQuery(this).parent().find('.scroll-icon').css('left', jQuery(this).outerWidth());
            jQuery(this).parent().find('.scroll-icon').css('top', jQuery(this).outerHeight());
        }
        jQuery(this).scroll(function() {
            jQuery(this).parent().find('.scroll-icon').stop().fadeOut();
        });
    });
}

/* Link options */
function linkSelects() {
    jQuery('select.linked').on('change', function() {
        optionHref = jQuery(this).val();
        if ( optionHref != '#' ) {
            location.href = optionHref;
        }
    });
}

/* Filter everything links on shop home */
function filterEverythingLinksOnShopHome() {
    if (jQuery('.page-template-shop-home').length) {
        bscCurrentPageUrl.replace( bscCurrentPageUrl, bscShopPageUrl);
        jQuery('.page-template-shop-home .wpc-filter-content ul li div').each(function( index ) {
            updatedUrl = jQuery(this).find('label a').attr('href').replace( bscCurrentPageUrl, bscShopPageUrl);
            jQuery(this).find('label a').attr('href', updatedUrl);
            jQuery(this).find('input').attr('data-wpc-link', updatedUrl);
            jQuery(this).find('input').prop('checked', false);
        });
    }
}

/* Filter visibility on shop home */
function filterVisibilityOnShopHome() {
    jQuery('.js-off-canvas-overlay.is-overlay-fixed.is-closable').on('click', function() {
        jQuery('#offCanvasLeft1').removeClass('is-open');
        jQuery('#offCanvasLeft1').addClass('is-closed');
    });
}

/* Open sub menus in mobile menu on load */
function openSubMenuInMobileMenuOnLoad() {
    jQuery('.offcanvas-menu-button.hide-for-large').on('click', function() {
        jQuery('.mobile-navigation > ul.menu-main-navigation > li.current-menu-ancestor > .more').click();
    });
}
