# babaà step child

## Description

If you don't have a child theme and still want to use your own css and js files, just like in a child theme, this is for you. 
This plugin loads css and js from files instead of using Customizer or other solutions that creates inline code.

## Installation

1. Upload `babaa-step-child` to the `/wp-content/plugins/` directory.
2. Activate the plugin through the 'Plugins' menu in WordPress.
3. Edit the scss file in babaa-step-child/scss/, and build, see below. And edit the js file in babaa-step-child/js/.

## Build css

If you don't have sass on your computer simly open a terminal and run: gem install sass.

1. Open terminal and run: sh watch-compressed.sh from /your-install/wp-content/plugins/babaa-step-child/scss/
2. This will watch style.scss and all included scss files for changes and build ../css/style.css

## Add php functions

In the directory `functions` there are three sub directories to keep this nice and tidy:

1. `plugins`
2. `themes`
3. `wordpress`

Add your custom code to a file in one of these three directories, where you see fit. If you have added a new file, add a require_once for your new file in index.php for that directory.
 
## Changelog

### 1.2.7

* Gutenberg button style
* Disable cart fragments code in Shopkeeper
* Minify js
* Hide filter on sale page css
* Bug fix, hide hidden blog categories from blog tag archive 
* Recache for product categories
* Crash safe(r) recache for products
* Fix for text column on single product page if smaller than image column
* Switch for minified js
* Fix for automatically open sub menus in mobile, new class in theme
* Automatically open sub menus in mobile, fix for single products
* Automatically open sub menus in mobile, fix for blog posts
* Automatically open sub menus in mobile, fix for blog categories
* Position of logged in user in admin bar
* Javascript check if product info exists for product pages where text column is smaller than image column
* Better check for updates of the Step Child plugin
* Hide Explore button on sale page
* Logo and close icon fix for Explore canvas

#### Steps to take before deploy

* Add classes shop, blog, about and support to menu items respectively (done)
* Remove Additional CSS in Customize: Sale page, no filter button fix (done)

## Deployed

### 1.2.6

* Close mobile menu icon made visible
* Keep submenu open on subpages in mobile view

### 1.2.5

* Check for admin before setting header meta

### 1.2.4

* Replace Yoast SEO with Excerpt and ACF
* Better *Recache all products*
* Fix cusomization in new version of Fancybox

#### Steps to take before deploy

* Delete *Yoast SEO* plugin [More info](https://yoast.com/help/how-can-i-uninstall-my-plugin/)

#### Steps to take after deploy
* Drop table wp_yoast_indexable
* Drop table wp_yoast_indexable_hierarchy
* Drop table wp_yoast_migrations
* Drop table wp_yoast_primary_term
* Drop table wp_yoast_seo_links
* Drop table wp_yoast_seo_meta
* Run *wp db cli* and then *delete from wp_postmeta where meta_key like '%wpseo_%';*
* Sync ACF fields
* Go to [Customise](https://babaa.es/wp-admin/customize.php) and select an image under *Fallback images > Fallback OG image*
* Add Excerpt to Blog page (1)
* Add Excerpt to Start page (2)
* Add Excerpt to Shop home (2)
* Update *Fancybox plugin*, and then go to [Settings > Media](https://babaa.es/wp-admin/options-media.php) and change *Version* to *Legacy*

(1)
Our blog posts are not just all about our lovely knits, we also poems, photographs and artwork from our favorite writers and artists. Some come on in..

(2)
WEAR FOREVER knits from local spanish farmers - to YOU. Free Shipping On All Orders Over €100. LOVE FOREVER and ever. 

### 1.2.3

* Logo on login screen
* Empty dashboard
* Recache all products

#### Steps to take after deploy

* Delete *White Label CMS*
* Delete *Advanced Editor Tools (previously TinyMCE Advanced)*

### 1.2.2

* Error notices on checkout not visible, fixed
* Disable *Popup Anything on Click Pro* shortcode
* Exclude newsletter popup from checkout
* New maintenance system
* Add to cart notice not working on variable products
* Coupon text on checkout

#### Steps to take after deploy

* Disable and uninstall *Popup Anything on Click Pro*
* Edit the [mailchimp signup popup](https://babaa.es/wp-admin/post.php?post=148556&action=edit) and check *Exclude from cart and checkout*
Install [https://wordpress.org/plugins/wp-maintenance/](https://wordpress.org/plugins/wp-maintenance/) and edit the settings to match Staging
Uninstall *SeedProd Pro*
Edit [DISABLE SALE](https://babaa.es/wp-admin/admin.php?page=edit-snippet&id=15) and change *woocommerce_get_sale_price* to *woocommerce_product_get_sale_price* and *woocommerce_get_price* to *woocommerce_product_get_price*

### 1.2.1

* Minor fixes for Shop home
* Editorials/Photoshoots page
* Bug fix, identify Shop home template in javascript
* Keep submenu open on subpages in mobile view

### 1.2.0

* Change home URL in breadcrumb
* Css for search product block
* Customizer setting for shop home page
* Better filter
* Shop home, template with filter
* Change link texts in breadcrumb
* Breadcrumbs more pronounced
* Change Filter to Refine
* Change text in search field

#### Steps to take before deploy

* Install and configure [Filter Everything](https://wordpress.org/plugins/filter-everything/)
* Add widgets for the filter

### 1.1.9

* Always include CoBlocks css if CoBlocks is installed
* Position of close X on pop ups for smaller screens
* No background color for close mobile menu icon
* Arrow on mega menu for desktop to indicate scrolling is possible

### 1.1.8

* Mailchimp forms prettier
* Gallery for pop ups fix

### 1.1.7

* Tracking style
* Custom 404 page
* Possibility to hide blog categories from post list page

### 1.1.6

* Do not open subscribe pop up if another pop up is currently open
* Make subscribe confirm appear faster by checking post for Mailchimp
* Better looking pop up
* Prettier checkout content on top
* Mailchimp checkbox in checkout, styling
* Checkout capitalized headers
* Don't add pop up buttons to variations
* Add to cart flyout style for products with variations

#### Steps to take after deploy

* Remove temporary css for hiding *.single_variation* in **/wp-admin/customize.php > Additional CSS**

On both **babaà checkout** and **cart**:

* ~~Edit **Row settings** and add **Row ID**: *cart-n-checkout-info*~~ Already added.
* Edit the first row **free shipping on all orders over €100** and remove bold and make it a *H4*

### 1.1.5

* Columns for pop up post type
* Fix for Gutenberg spacer in Shopify
* Add support for Visual Composer to pop ups

### 1.1.4

* Renamed pop up post type
* Open a pop up automatically

### 1.1.3

* Popups from ACF instead of inline code in short description
* ACF json saved to plugin folder
* Custom post type for pop ups

#### Steps to take before deploy
* Install plugin ACF Pro
* Install Easy FancyBox
* Check Enable FancyBox for **Inline content**: **/wp-admin/options-media.php**

#### Steps to take after deploy
* Resave permalinks
* Test to create a post with the new post type
* Add support for duplicating pop up posts: **/wp-admin/options-general.php?page=duplicatepost**
* Find **mailchimp signup popup** (148556) and copy the **privacy policy** html, save it somewhere
* Run `UPDATE wp_posts SET post_type = 'babaa_pop_ups' WHERE post_type = 'aoc_popup'`
* Edit the moved mailchimp pop up and add the html copied from **mailchimp signup popup** (148556)
* Add the new popups to all products and at the same time remove the short code **[popup_anything id="..."]** from **Product short description**
* Deactivate and remove **Popup Anything on Click Pro**

### 1.1.2

* Fix stray p tags in faq
* Shorter timeout for update, was: 6 hours, now: 4 hours
* Breadcrumbs not available after adding to cart on single product page, fixed

### 1.1.1

* Multiple filters
* Filter: Even prettier, tighter
* Smaller logo
* Placeholder for search

#### Steps to take after deploy
* Update widgets accordingly in **Shop sidebar** (see staging)

### 1.1.0

* Fix filter not opening on desktop
* Filter: Prettier
* Filter: Dropdown for color
* Filter: Dropdown for number
* Filter: Select for category
* Filter: Better clear filter link
* Moved unlinking of menu headers from js to css

#### Steps to take after deploy
* Update widgets accordingly in **Shop sidebar** (see staging)
* Remove class alignleft on logo in widget in **Shop sidebar**

### 1.0.9

* Fix for shopping bag on smaller screens
* Hide titles on images, fix require

### 1.0.8

* Footer font lighter
* Breadcrumbs bigger
* Always hide WooCommerce tabs
* Hide titles on images

### 1.0.7

* Css for wp-admin added
* Style for Coblocks
* Style for links in content
* Clean up legacy css

#### Steps to take after deploy
* If you want to be able to work with Gutenberg, go to **/wp-admin/admin.php?page=vc-general** and uncheck **Disable Gutenberg Editor**, and save.
* Install plugin [Coblocks](https://wordpress.org/plugins/coblocks/) to get more blocks to work with in Gutenberg. The new FAQ is built with a block from Coblocks.

### 1.0.6

* Mobile menu font size
* All headers in menu unlinked
* Possibility to hide second level links in menu
* Sale badge style
* Fix bug in mobile menu where X appeared too late
* Fix bug in mobile menu where it still appeared after resizing
* Possibility to hide headers in menu

#### Steps to take after deploy
If you want to hide headers in menu, go to **/wp-admin/nav-menus.php** and add class *hidden* to headers you don't want visible, like *about >* **about us** and *support >* **customer support**.

### 1.0.5

* New font
* Update repo
* Add to cart notice modifications

#### Steps to take after deploy
Go to **/wp-admin/customize.php** and change Headings Font Source and Body Font Source to Custom Fonts. And in Headings Font and Body Font you enter *relative-book*

### 1.0.4

* Add to cart notice

### 1.0.3

* Cart icon

### 1.0.2

* Menu header links

### 1.0.1

* Added support for functions

### 1.0.0

* Ready for deploy

#### Steps to take after deploy
Go to **/wp-admin/customize.php** and then *Additional CSS*. Delete all the css in there. Go to **/wp-admin/plugins.php** and deactivate *Simple Custom CSS*.

### 0.0.1

* Initial release
