<?php
/* Custom excerpt */
function get_the_custom_excerpt( $chars = 160, $postId = null, $excerpt_raw = null ) {
	if ( $chars == null ) {
		$chars = 160;
	}
	if ( $excerpt_raw === null ) {
		$excerpt_raw = get_the_excerpt( $postId );
		if ( !$excerpt_raw ) {
			$excerpt_raw = get_the_content( $postId );
		}
	}
	//$excerpt = $excerpt_raw;
	$excerpt = rtrim( $excerpt_raw, '[&hellip;]' );
	//$excerpt = preg_replace( " ([.*?])", '', $excerpt_raw );
	$excerpt = strip_shortcodes( $excerpt );
	$excerpt = strip_tags( $excerpt );
	$excerpt_len = strlen( $excerpt );
	$excerpt = mb_substr( $excerpt, 0, $chars );
	//$excerpt = substr($excerpt, 0, strripos($excerpt, " "));
	$excerpt = trim( preg_replace( '/\s+/', ' ', $excerpt ) );
	$dots = '';
	if ( $excerpt_len > $chars ) {
		$dots = ' ...';
	}
	return $excerpt . $dots;
}

/* Make default excerps longer */
function babaa_custom_excerpt_length( $length ) {
    return 100;
}
add_filter( 'excerpt_length', 'babaa_custom_excerpt_length', 999 );
