<?php
/**
* Plugin Name: babaà step child
* Plugin URI: https://babaa.es/
* Description: Load css, js, fonts and php instead of relying on Customizer/Additional CSS and various plugins.
* Version: 1.2.8
* Author: Jonk @ Follow me Darling
* Author URI: https://followmedarling.se/
* Domain Path: /languages
* Text Domain: bsc
**/

defined( 'ABSPATH' ) or die( 'No script kiddies please!' );

/* Load language */
add_action( 'init', 'bsc_load_textdomain' );
function bsc_load_textdomain() {
    load_plugin_textdomain( 'bsc', false, dirname( plugin_basename( __FILE__ ) ) . '/languages' ); 
}

/* Set ver to this like so: bsc_get_asset_last_modified_time( get_theme_file_path( 'js/file.js' ) ) to get the time modded as ver */
function bsc_get_asset_last_modified_time( $path ) {
	return gmdate( 'YmdHis', filemtime( $path ) );
}

/* Get current plugin version number */
function bsc_get_plugin_version() {
	$plugin_version = get_file_data( __FILE__, array( 'Version' => 'Version' ), false )['Version'];
	return esc_attr( $plugin_version );
}

/* Enque the files for front end */
add_action( 'wp_enqueue_scripts', 'enqueue_bsc', 999 );
function enqueue_bsc() {
    // Style
    wp_register_style( 
        'bsc-style', 
        plugins_url( 'css/style.css', __FILE__ ),
        array(),
        bsc_get_asset_last_modified_time( plugin_dir_path( __FILE__ ) . 'css/style.css' )
    );
    wp_enqueue_style( 'bsc-style' );
    // Script
    $minify = true;
    if ( $minify ) {
        $script_file = 'script.min.js';
    } else {
        $script_file = 'script.js';
    }
    wp_register_script( 
        'bsc-script', 
        plugins_url( 'js/' . $script_file, __FILE__ ),
        array( 'jquery' ), 
        bsc_get_asset_last_modified_time( plugin_dir_path( __FILE__ ) . 'js/' . $script_file ),
        true
    );
    wp_enqueue_script( 'bsc-script' );
}

/* Enque the files for back end */
if ( is_admin() ) {
	add_action( 'admin_enqueue_scripts', 'enqueue_bsc_admin' );
	function enqueue_bsc_admin() {
        // Style
		wp_register_style( 
            'bsc-admin-style', 
            plugins_url( 'css/wp-admin.css', __FILE__ ), 
            array(), 
            bsc_get_asset_last_modified_time( plugin_dir_path( __FILE__ ) . 'css/wp-admin.css' ),
        );
        wp_enqueue_style( 'bsc-admin-style' );
	}
}

/* Enque the files for log in */
if ( !has_action( 'login_enqueue_scripts', 'wp_print_styles' ) ) {
	add_action( 'login_enqueue_scripts', 'enqueue_bsc_login' );
	function enqueue_bsc_login() {
        // Style
		wp_register_style( 
            'bsc-login-style', 
            plugins_url( 'css/wp-login.css', __FILE__ ), 
            array(), 
            bsc_get_asset_last_modified_time( plugin_dir_path( __FILE__ ) . 'css/wp-login.css' ),
        );
        wp_enqueue_style( 'bsc-login-style' );
	}
}

/* Include stuff */
include_once( 'inc/repo.php' );

include_once( 'inc/acf-json.php' );

/* Require functions */
require_once( 'functions/wordpress/index.php' );

require_once( 'functions/plugins/index.php' );

require_once( 'functions/themes/index.php' );

require_once( 'functions/recache-products.php' );