<?php
// Not used as is, but can be used for inspiration for new shop home

function menu_dropdown_function( $atts ) {
	extract( shortcode_atts( array(
		'menu_id' => 42,
		'parent_menu_item_id' => 0,
	), $atts ) );
    if ( !is_admin() ) {
        $dump = '';
        if ( $parent_menu_item_id == 0 ) {
            $menu = wp_get_nav_menu_items( $menu_id, array( 
                'posts_per_page' => -1,
            ) );
            $dump = var_export( $menu, true );
            return '<pre>' . $dump . '</pre>';
        } else {
            return get_sub_menu_items_by_id( $menu_id, $parent_menu_item_id );
        }
    } else {
        return false;
    }
}
add_shortcode( 'menu_dropdown', 'menu_dropdown_function' );

function get_sub_menu_items_by_id( $menu_id, $parent_menu_item_id ) {
    $menu_items = wp_get_nav_menu_items( $menu_id, array( 
        'posts_per_page' => -1,
    ) );
    $return_drops = '<select class="linked">';
    foreach( $menu_items as $menu_item ) {
        if ( $menu_item->ID == $parent_menu_item_id ) {
            $return_drops .= '<option value="' . $menu_item->url . '">' . $menu_item->title . '</li>';
        }
        if ( $menu_item->menu_item_parent == $parent_menu_item_id ) {
            if ( in_array( 'upper', $menu_item->classes ) ) {
                $return_drops .= '</select>';
                $return_drops .= '<select class="linked">';
            }
            $return_drops .= '<option value="' . $menu_item->url . '">' . $menu_item->title . '</li>';
        }
    }
    $return_drops .= '</select>';
    return $return_drops;
}

function wc_attribute_dropdown_function( $atts ) {
    extract( shortcode_atts( array(
		'taxonomy' => 'pa_color',
	), $atts ) );
	return get_wc_attributes_to_dropdown( $taxonomy );
}
add_shortcode( 'wc_attribute_dropdown', 'wc_attribute_dropdown_function' );

function get_wc_attributes_to_dropdown( $taxonomy ) {
    $taxonomies = get_terms(
        array(
            'taxonomy' => $taxonomy
        )
    );
    $taxonomy_filter_name = explode("pa_", $taxonomy);
    $taxonomy_name = wc_attribute_label( $taxonomy );
    if ( !empty( $taxonomies ) ) {
        $output = '<select class="linked">';
        $output .= '<option value="#">' . __( 'find by:', 'bsc' ) . ' ' . $taxonomy_name . '</option>';
        foreach( $taxonomies as $wc_attr ) {
            if ( $wc_attr->parent == 0 ) {
                $output.= '<option value="' . get_permalink( wc_get_page_id( 'shop' ) ) . '?attr_' . $taxonomy_filter_name[1] . '=' . esc_attr( $wc_attr->slug ) .'">';
                    $output.= $wc_attr->name;
                $output.='</option>';
            }
        }
        $output.='</select>';
        return $output;
    }
}
