<?php
// WooCommerce

// Add popup buttons after short description on single product page
add_filter( 'woocommerce_short_description', 'add_pop_up_buttons_after_excerpt_single_product', 20, 1 );
function add_pop_up_buttons_after_excerpt_single_product( $post_excerpt ) {
    if ( have_rows( 'pop_up_buttons' ) && is_single() ):
        $pop_up_buttons = '<div class="wp-block-columns pop-up-buttons">';
        $pop_up_fancyboxes = '';
        $pop_up_buttons_count = count( get_field( 'pop_up_buttons' ) );
        if ( $pop_up_buttons_count == 4) {
            $pop_up_buttons_count = 2;
        }
        while ( have_rows( 'pop_up_buttons' ) ) : the_row();
            $button_text = get_sub_field( 'button_text' );
            $pop_up = get_sub_field( 'pop_up' );
            if ( $pop_up ) {
                $pop_up_ID = $pop_up->ID;
            } else {
                $pop_up_ID = get_sub_field( 'pop_up_id' );
            }
            if ( $pop_up_ID ) {
                $pop_up_buttons .= '<div class="wp-block-column">';
                    $pop_up_buttons .= '<div class="wp-block-buttons">
                        <div class="wp-block-button has-custom-width wp-block-button__width-100 is-style-outline">
                            <a href="#fancyboxID-' . $pop_up_ID . '" class="wp-block-button__link fancybox-inline" data-pop-up-id="' . $pop_up_ID . '">' . $button_text . '</a>
                        </div>
                    </div>';
                $pop_up_buttons .= '</div><!-- /.wp-block-column -->';
                // $pop_up_content = get_the_content( null, false, $pop_up_ID );
                $pop_up_content = do_shortcode( get_the_content( null, false, $pop_up_ID ) ); // Visual Composer made me do it.
                $pop_up_fancyboxes .= '<div style="display:none" class="fancybox-hidden">
                    <div id="fancyboxID-' . $pop_up_ID . '" class="hentry fancybox-inner-content">
                        ' . $pop_up_content . '
                    </div>
                </div>';
                //echo $pop_up_content;
            }
        endwhile;
        $pop_up_buttons .= '</div><!-- /.wp-block-columns -->';
        $post_excerpt = $post_excerpt . "\n" . $pop_up_buttons . "\n" . $pop_up_fancyboxes;
        //$pop_up_buttons_shortcode = do_shortcode( $pop_up_buttons . $pop_up_containers );
        //return $post_excerpt . do_shortcode( $pop_up_buttons_shortcode );
    endif;
    return $post_excerpt;
}

// Make sure the pop up buttons don't appear in the variations description
add_filter( 'woocommerce_available_variation', 'dont_add_pop_up_buttons_to_variations', 10, 3);
function dont_add_pop_up_buttons_to_variations( $data, $product, $variation ) {
    $data['variation_description'] = wpautop( get_post_meta($variation->get_id(), '_variation_description', true) );
    return $data;
}

/* Change home URL in WooCommerce breadcrumb */
add_filter( 'woocommerce_breadcrumb_home_url', 'babaa_woo_custom_breadrumb_home_url' );
function babaa_woo_custom_breadrumb_home_url() {
    if ( get_theme_mod( 'home_page_for_shop_link' ) ) {
        $home_page_for_shop_link = get_permalink( get_theme_mod( 'home_page_for_shop_link' ) );
    } else {
        $home_page_for_shop_link = home_url();
    }
	return $home_page_for_shop_link;
}

/* Rename shop link text in WooCommerce breadcrumb */
add_filter( 'woocommerce_get_breadcrumb', 'babaa_custom_get_breadcrumb', 20, 2 );
function babaa_custom_get_breadcrumb( $crumbs, $breadcrumb ){
    $target = 'shop';
    foreach($crumbs as $key => $crumb){
        if( $target === strtolower( $crumb[0] ) ){
            $crumbs[$key][0] = __( 'all items', 'bsc' );
        }
    }
    $target = 'home';
    foreach($crumbs as $key => $crumb){
        if( $target === strtolower ( $crumb[0] ) ){
            $crumbs[$key][0] = __( 'shop', 'bsc' );
        }
    }
    return $crumbs;
}

/* Replace the strings */
if ( !is_admin() ) {
    function woocommerce_texts( $translated ) {
        $text = array( 
            'Search products...' => 'Search items...', 
            'Search products…' => 'Search items…', 
            'Search products' => 'Search items', 
            'Search products&hellip;' => 'Search items&hellip;', 
            'Have a coupon?' => 'Have a coupon or store credit?', 
        );
        $translated = str_ireplace( array_keys( $text ), $text, $translated );
        return $translated;
    }
    add_filter( 'gettext', 'woocommerce_texts', 20 );
}

/* Remove cart fragments */
function babaa_remove_filter_fragments() {
    remove_filter( 'woocommerce_add_to_cart_fragments', 'shopkeeper_shopping_bag_items_number' );
}
add_action( 'after_setup_theme', 'babaa_remove_filter_fragments', 50 );
/*
// Handled by Perfmatters
function babaa_dequeue_woocommerce_cart_fragments() { 
    wp_dequeue_script( 'wc-cart-fragments' ); 
}
add_action( 'wp_enqueue_scripts', 'babaa_dequeue_woocommerce_cart_fragments', 11 );
*/

/* Block PO Boxes from order */
add_action('woocommerce_after_checkout_validation', 'babaa_deny_pobox_postcode');
function babaa_deny_pobox_postcode( $posted ) {
    global $woocommerce;

    $address  = ( isset( $posted['shipping_address_1'] ) ) ? $posted['shipping_address_1'] : $posted['billing_address_1'];
    $postcode = ( isset( $posted['shipping_postcode'] ) ) ? $posted['shipping_postcode'] : $posted['billing_postcode'];

    $replace  = array(" ", ".", ",");
    $address  = strtolower( str_replace( $replace, '', $address ) );
    $postcode = strtolower( str_replace( $replace, '', $postcode ) );

    if ( strstr( $address, 'pobox' ) || strstr( $postcode, 'pobox' ) ) {
        wc_add_notice( sprintf( __( "Sorry, we cannot ship to PO BOX addresses.") ) ,'error' );
    }
}

/* Remove Via Woocom on apple pay */
add_filter( 'wc_stripe_payment_request_total_label_suffix', 'babaa_remove_apple_pay_label_suffix' );
function babaa_remove_apple_pay_label_suffix( $stripe_params ){
	return '';
}

/* Reorder billing fields on checkout */
add_filter( 'woocommerce_checkout_fields', 'babaa_billing_fields_reorder' );
function babaa_billing_fields_reorder( $checkout_fields ) {
	$checkout_fields[ 'billing' ][ 'billing_email' ][ 'priority' ] = 1;
	return $checkout_fields;
}

/* Auto log out user after shopping */
add_action( 'woocommerce_payment_complete', 'log_out_after_payment_complete', 10, 1 );
function log_out_after_payment_complete() {   
    wp_logout();
}

// Moved to separate plugin
/*
add_filter( 'wc_facebook_fb_retailer_id', 'babaa_facebook_fb_retailer_id', 10, 2 );
function babaa_facebook_fb_retailer_id() {
    global $product;
    if ( $product ) {
        $woo_id = $product->get_id();
        // $woo_id = $product->get_sku();
        return strval( $woo_id );
    }
}
*/

/* Add taxonomy for hidden tags: Instagram tags */
function babaa_register_instagram_taxonomy_for_product() {
	$labels = array(
		'name'              => _x( 'Instagram tags', 'taxonomy general name', 'bsc' ),
		'singular_name'     => _x( 'Instagram tag', 'taxonomy singular name', 'bsc' ),
		'search_items'      => __( 'Search Instagram tags', 'bsc' ),
		'all_items'         => __( 'All Instagram tags', 'bsc' ),
		'parent_item'       => __( 'Parent Instagram tag', 'bsc' ),
		'parent_item_colon' => __( 'Parent Instagram tag:', 'bsc' ),
		'edit_item'         => __( 'Edit Instagram tag', 'bsc' ),
		'update_item'       => __( 'Update Instagram tag', 'bsc' ),
		'add_new_item'      => __( 'Add Instagram tag', 'bsc' ),
		'new_item_name'     => __( 'New Instagram tag', 'bsc' ),
		'menu_name'         => __( 'Instagram tags', 'bsc' ),
	);
	$args = array(
		'hierarchical' => false,
		'labels' => $labels,
		'query_var' => false,
		'rewrite' => array(
			'slug' => __( 'instagram-tag', 'bsc' ),
			'with_front' => false,
		),
		'public' => false,
		'show_ui' => true,
		'show_tagcloud' => false,
		'show_in_nav_menus' => false,
		'show_admin_column' => true,
	);
	register_taxonomy( 'instagram-tag', 'product', $args );
}
add_action( 'init', 'babaa_register_instagram_taxonomy_for_product', 0 );
