<?php
// Categories

// Hide selected categories
function babaa_set_terms_args( $args, $taxonomies ) {
    if ( ( is_home() || is_archive() ) && $taxonomies[0] == 'category' ) {
        $args['meta_query'] = array(
            'relation' => 'OR',
            array(
                'key'     => 'visibility',
                'value'   => 'hide',
                'compare' => 'NOT LIKE',
            ),
            array(
                'key'     => 'visibility',
                'compare' => 'NOT EXISTS',
            )
        );
    }
    return $args;
}
add_filter( 'get_terms_args', 'babaa_set_terms_args', 10, 2 );

// Columns in admin for hidden categories
function babaa_category_change_columns( $columns ) {
    $columns['hidden_cat'] = __( 'Hidden', 'bsc' );
    return $columns;
}
add_filter( 'manage_edit-category_columns', 'babaa_category_change_columns' );

function babaa_category_custom_columns( $deprecated, $column_name, $term_id ) {
    if ( $column_name == 'hidden_cat' ) {
        if ( get_field( 'visibility', 'term_' . $term_id ) ) {
			echo '&check;';
		}
    }
}
add_filter ( 'manage_category_custom_column', 'babaa_category_custom_columns', 10, 3) ;
