<?php
// Custom post types
function create_babaa_post_types() {

	// Pop ups
	register_post_type( 'babaa_pop_ups',
		array(
			'labels' => array(
				'name' => __( 'Pop ups', 'bsc' ),
				'singular_name' => __( 'Pop up', 'bsc' ),
				'all_items' => __( 'All pop ups', 'bsc' ),
				'add_new' => __( 'Add pop up', 'bsc' ),
				'add_new_item' => __( 'Add pop up', 'bsc' ),
				'edit_item' => __( 'Edit pop up', 'bsc' ),
				'view_item' => __( 'Show pop up', 'bsc' ),
				'search_items' => __( 'Find pop up', 'bsc' )
			),
			'public' => true,
			'supports' => array( 
				'title', 
				'editor', 
				'revisions' 
			),
			'rewrite' => array(
				'slug' => __( 'babaa-pop-up', 'bsc' ) 
			),
			'publicly_queryable' => false,
			'query_var' => true,
			'exclude_from_search' => true,
			'menu_position' => 25,
			'show_in_rest' => true, // gutenberg
			'menu_icon' => 'dashicons-editor-expand' //https://developer.wordpress.org/resource/dashicons/
		)
	);

	// Instagram collection
	/*
	register_post_type( 'babaa_instagram_coll',
		array(
			'labels' => array(
				'name' => __( 'Instagram collections', 'bsc' ),
				'singular_name' => __( 'Instagram collection', 'bsc' ),
				'all_items' => __( 'All Instagram collections', 'bsc' ),
				'add_new' => __( 'Add Instagram collection', 'bsc' ),
				'add_new_item' => __( 'Add Instagram collection', 'bsc' ),
				'edit_item' => __( 'Edit Instagram collection', 'bsc' ),
				'view_item' => __( 'Show Instagram collection', 'bsc' ),
				'search_items' => __( 'Find Instagram collection', 'bsc' )
			),
			'public' => true,
			'supports' => array( 
				'title', 
				'revisions' 
			),
			'rewrite' => array( 
				'slug' => __( 'babaa-instagram-collectiona', 'bsc' ),
				'with_front' => false 
			),
			'publicly_queryable' => false,
			'query_var' => true,
			'exclude_from_search' => true,
			'menu_position' => 25,
			'show_in_rest' => false, // gutenberg
			'menu_icon' => 'dashicons-format-image' //https://developer.wordpress.org/resource/dashicons/
		)
	);
	*/
}
add_action( 'init', 'create_babaa_post_types' );

// Columns in admin for Pop ups
function babaa_pop_up_change_columns( $cols ) {
	$cols = array(
		'title'		=> __( 'Title' ),
		'pop-up'	=> __( 'Auto', 'bsc' ),
		'date'		=> __( 'Date' )
	);
	return $cols;
}
add_filter( "manage_babaa_pop_ups_posts_columns", "babaa_pop_up_change_columns" );
function babaa_pop_up_custom_columns( $column ) {
	global $post;
	if ( $column == 'pop-up' ) {
		if ( get_field( 'pop_up_settings_automatically_appear' ) ) {
			echo '&check;';
		}
	}
}
add_action( "manage_babaa_pop_ups_posts_custom_column", "babaa_pop_up_custom_columns", 10, 2 );
