/* Stops Products_infos at WooCommerce tabs */
jQuery( function($) {

	'use strict';

	function product_infos_adjust() {
		// if product description is too long
		var productInfosHeight 			= $('.product .product_content_wrapper .product_infos').length ? $('.product .product_content_wrapper .product_infos').outerHeight() : 0;
		var productInfosPos	   			= $('.product .product_content_wrapper .product_infos').position().top;
		var productInfosWidth  			= $('.product .product_content_wrapper .product_infos').length ? $('.product .product_content_wrapper .product_infos').outerWidth() : 0;
		var productContentWrapperOff 	= $('.product_content_wrapper').offset().top;

		if (  (productInfosHeight >  $(window).innerHeight() - productContentWrapperOff) && ($(window).width() >= 1024) ) {
			$('.product_infos').addClass('long-description'); // product description is longer than actual viewport
		} else {
			$('.product_infos').css({ top: productContentWrapperOff });
		}
	}

	if ( ($('.product_layout_cascade').length > 0) || ($('.product_layout_scattered').length > 0) ) {

		product_infos_adjust();

		// if product_infos is at at footer, stop it.
		$(window).on( 'scroll', function() {

            var windowTop = $(window).scrollTop();
            var footerTop = $(".woocommerce-tabs").length ? $(".woocommerce-tabs").offset().top : $("#site-footer").offset().top; // jonk fix offset for woo tabs
            var productInfosOff = $('.product_infos.fixed').offset().top;
            var productInfosH = $(".product_infos.fixed").length ? jQuery(".product_infos.fixed").height() : 0;
            var padding = 40;  // let a distance between the product_infos and the footer
            var productContentWrapperOff = $('.product_content_wrapper').length ? $('.product_content_wrapper').offset().top : 0;
        
            if (windowTop + productInfosH + 200 > footerTop - padding ) {
        
                $('.product_infos.fixed:not(.long-description)').css({
                    top: (windowTop + productInfosH - footerTop + padding) * -1
                });
        
            } else {

                $('.product_infos.fixed:not(.long-description)').css({
                    top :  productContentWrapperOff
                });
            }
        
        });
        

		$(window).on( 'orientationchange', function() {
			product_infos_adjust();
		});
	}

});