<?php
// Custom post type: Editorials

// Create custom post type
function create_babaa_editorials_post_type() {
	
	register_post_type( 'babaa_editorials',
		array(
			'labels' => array(
				'name' => __( 'Editorials', 'bsc' ),
				'singular_name' => __( 'Editorial', 'bsc' ),
				'all_items' => __( 'All editorials', 'bsc' ),
				'add_new' => __( 'Add editorial', 'bsc' ),
				'add_new_item' => __( 'Add editorial', 'bsc' ),
				'edit_item' => __( 'Edit editorial', 'bsc' ),
				'view_item' => __( 'Show editorial', 'bsc' ),
				'search_items' => __( 'Find editorial', 'bsc' )
			),
			'public' => true,
			'supports' => array( 
				'title', 
				'editor', 
				'revisions',
				'excerpt', 
				'thumbnail'
			),
			'rewrite' => array(
				'slug' => __( 'editorial', 'bsc' ),
				'with_front' => false
			),
			'has_archive' => true,
			'publicly_queryable' => true,
			'query_var' => true,
			'exclude_from_search' => false,
			'menu_position' => 6,
			'show_in_rest' => true, // gutenberg
			'menu_icon' => 'dashicons-media-document' //https://developer.wordpress.org/resource/dashicons/
		)
	);
	
}
add_action( 'init', 'create_babaa_editorials_post_type' );

// Create archive
function babaa_editorials_archive( $template ) {
	if ( is_post_type_archive( 'babaa_editorials' ) ) {
		return plugin_dir_path( __FILE__ ) . 'archive-babaa_editorials.php';
	}
	return $template;
}
add_filter( 'template_include', 'babaa_editorials_archive' );

// Set number of posts to load on archive
function num_posts_archive_editorial( $query ) {
    if ( !is_admin() && $query->is_archive( 'editorial' ) && $query->is_main_query() ) {
            $query->set( 'posts_per_page', 12 );
   }
    return $query;
}
add_filter( 'pre_get_posts', 'num_posts_archive_editorial' );
