<?php
/*
Template Name: Shop home
*/
?>

<?php

	$page_id = shopkeeper_get_page_id();

    $page_header_src = "";

    if (has_post_thumbnail()) $page_header_src = wp_get_attachment_url( get_post_thumbnail_id( $page_id ) );

	if (get_post_meta( $page_id, 'page_title_meta_box_check', true )) {
		$page_title_option = get_post_meta( $page_id, 'page_title_meta_box_check', true );
	} else {
		$page_title_option = "on";
	}

?>

<?php get_header(); 

// Variables for the javascript
$shop_page_url = get_permalink( wc_get_page_id( 'shop' ) );
echo '<script type="text/javascript">
    bscShopPageUrl = \'' . $shop_page_url . '\';
    bscCurrentPageUrl = \'' . get_permalink() . '\';
</script>';

// Initiate the filter set WP Query
$args = array(
    'posts_per_page' => 1,
    'post_type' => 'product',
    'meta_query' => array(
        array(
            'key' => '_stock_status',
            'value' => 'instock',
            'compare' => '=',
        ),
    )
);
$wc_query = new WP_Query( $args);
?>

	<div class="full-width-page <?php echo ( (isset($page_title_option)) && ($page_title_option == "on") ) ? 'page-title-shown':'page-title-hidden';?>">

        <div class="left-column-widgets off-canvas position-left shop-has-sidebar is-closed" id="offCanvasLeft1" id="offCanvasLeft1" data-off-canvas="" aria-hidden="false" data-e="8siunu-e">
            <div class="menu-close">
                <button class="close-button" aria-label="Close menu" type="button" data-close="">
                    <span aria-hidden="true">×</span>
                </button>
            </div>
            <div class="offcanvas_content_left wpb_widgetised_column">
                <div id="filters-offcanvas">
                    <?php if ( is_active_sidebar( 'shop-home' ) ) : ?>
                        <?php dynamic_sidebar( 'shop-home' ); ?>
                    <?php endif; ?>
                </div>
            </div>
        </div>
        <div class="js-off-canvas-overlay is-overlay-fixed is-closable"></div>

        <div id="primary" class="content-area">

            <div id="content" class="site-content" role="main">
                
                <div id="button_offcanvas_sidebar_left" data-toggle="offCanvasLeft1" aria-expanded="false" aria-controls="offCanvasLeft1">
                    <span class="filters-text">
                        <i class="spk-icon spk-icon-menu-filters"></i>
                        Explore</span>
                </div>

                <header class="entry-header <?php if ($page_header_src != "") : ?>with_featured_img<?php endif; ?>" <?php if ($page_header_src != "") : ?>style="background-image:url(<?php echo esc_url($page_header_src); ?>)"<?php endif; ?>>

                    <div class="page_header_overlay"></div>

                    <div class="row">
                        <div class="large-12 columns">

                            <?php if ( (isset($page_title_option)) && ($page_title_option == "on") ) : ?>
                            <h1 class="page-title"><?php the_title(); ?></h1>
                            <?php endif; ?>

                            <?php if($post->post_excerpt) : ?>
                                <div class="page-description"><?php the_excerpt(); ?></div>
                            <?php endif; ?>

                        </div>
                    </div>

                </header><!-- .entry-header -->

                <?php while ( have_posts() ) : the_post(); ?>

                    <div class="entry-content">
                        <?php the_content(); ?>
                    </div><!-- .entry-content -->

                    <?php

                        // If comments are open or we have at least one comment, load up the comment template
                        if ( comments_open() || '0' != get_comments_number() ) comments_template();

                    ?>

                <?php endwhile; // end of the loop. ?>

            </div><!-- #content -->

        </div><!-- #primary -->

    </div><!-- .full-width-page -->

<?php get_footer(); ?>
