<?php

	$page_id = shopkeeper_get_page_id();

    $page_header_src = "";

    if (has_post_thumbnail()) $page_header_src = wp_get_attachment_url( get_post_thumbnail_id( $page_id ) );

    $page_title_option = "on";

	if (get_post_meta( $page_id, 'page_title_meta_box_check', true )) {
		$page_title_option = get_post_meta( $page_id, 'page_title_meta_box_check', true );
	}

    if (get_post_meta( $page_id, 'page_title_meta_box_check', true )) {
        $page_title_option = get_post_meta( $page_id, 'page_title_meta_box_check', true );
    } else {
        $page_title_option = "on";
    }

?>

<?php get_header(); ?>

    <div class="<?php echo ( (isset($page_title_option)) && ($page_title_option == "on") ) ? 'page-title-shown':'page-title-hidden';?>">

        <div id="primary" class="content-area">

            <div id="content" class="site-content" role="main">

           		<header class="entry-header">

                    <div class="page_header_overlay"></div>

                    <div class="row">
                        <div class="large-10 large-centered columns without-sidebar">

                            <?php if ( (isset($page_title_option)) && ($page_title_option == "on") ) : ?>
                                <h1 class="page-title">
                                    <?php _e( 'editorials', 'bsc' ); ?>
                                </h1>
                            <?php endif; ?>

                        </div>
                    </div>

                </header><!-- .entry-header -->

                <div id="post-<?php the_ID(); ?>" <?php post_class(); ?>>

                    <div class="row">
                        <div class="large-12 columns">

                            <div class="entry-content">

                                <div class="edotorial-list">
                                    <?php while ( have_posts() ) : the_post(); ?>
                                        <div>
                                            <a href="<?php the_permalink(); ?>">
                                                <?php if ( has_post_thumbnail( get_the_ID() ) ) { ?>
                                                    <?php the_post_thumbnail( 'medium_large' ); ?>
                                                <?php } ?>
                                                <h5>
                                                    <?php
                                                    $list_litle = get_field( 'list_title' ); 
                                                    if ( $list_litle ) {
                                                        echo $list_litle;
                                                    } else {
                                                        the_title();
                                                    }
                                                    ?>
                                                </h5> 
                                            </a>
                                        </div>
                                    <?php endwhile; // end of the loop. ?>
                                </div>

                            </div><!-- .entry-content -->

                            <div class="woocommerce">
                                <div class="woocommerce-after-shop-loop-wrapper">
                                    <?php
                                        babaa_pagination();
                                        wp_reset_query(); 
                                    ?>
                                </div>
                            </div>

                        </div><!-- .columns -->
                    </div><!-- .row -->

                </div><!-- #post -->
                

            </div><!-- #content -->

        </div><!-- #primary -->

    </div>

<?php get_footer(); ?>
