<?php

function on_save_babaa_instagram_coll( $post_id, $post, $update ) {

    // If this is a revision, get real post data
    /*
    $parent_id = wp_is_post_revision( $post_id );
    if ( $parent_id !== false ) {
        $post_id = $parent_id;
        $post = get_post( $post_id );
    }
    */

    // Ignore listing
    global $pagenow;
    if ( $pagenow == 'edit.php' ) {
        return;
    }

    // Ignore revisions
    if ( wp_is_post_revision( $post_id ) ) {
        return;
    }

    // Only set for post_type: post
    if ( $post->post_type !== 'babaa_instagram_coll' ) {
        return;
    }

    $post_status = $post->post_status ?? 'nothing';

    $do_action = 'ignore';

    $PRODUCT_SET_ID = get_post_meta( $post_id, 'PRODUCT_SET_ID', true );

    if ( !$PRODUCT_SET_ID && $post_status == 'publish' ) {
        // Create a collection
        // Also, get the ID from the API and save it to the post
        $PRODUCT_SET_ID = '12345' . '_' . $post_id; // Faking it for now
        update_post_meta( $post_id, 'PRODUCT_SET_ID', $PRODUCT_SET_ID );
        $do_action = 'create';
    } elseif ( $PRODUCT_SET_ID && $post_status == 'publish' ) {
        // Update the collection
        $do_action = 'update';
    } elseif ( $post_status == 'trash' ) {
        // Remove the collection
        $do_action = 'remove';
    } else {
        return;
    }

    do_on_save_babaa_instagram_coll_action( $post_id, $post, $update, $do_action );
}
add_action( 'save_post', 'on_save_babaa_instagram_coll', 10, 3 );

function do_on_save_babaa_instagram_coll_action( $post_id, $post, $update, $do_action ) {

    if ( $do_action != 'ignore' ) {
        $post_title = esc_html( get_the_title( $post_id ) );
        // $post_url = esc_url( get_permalink( $post_id ) );
        $subject = 'The collection "' . $post_title . '" has been ' . $do_action . 'd';

        $message = 'Data for the ' . $do_action . 'd collection.' . "\n\n";

        $message .= "Name: \n" . $post_title . "\n\n";
        // $message .= "Post URL (not used): \n" . $post_url . "\n\n";
        $message .= "Action: \n" . $do_action . "\n\n";
        $message .= "Post status: \n" . $post->post_status . "\n\n";
        $message .= "Cover image URL: \n" . wp_get_attachment_image_src( get_post_meta( $post_id, 'cover_image_url', true ), 'full' )[0] . "\n\n";
        $message .= "External URL: \n" . get_post_meta( $post_id, 'external_url', true ) . "\n\n";
        $message .= "Description: \n" . get_post_meta( $post_id, 'description', true ) . "\n\n";
        $message .= "Product set ID: \n" . get_post_meta( $post_id, 'PRODUCT_SET_ID', true ) . "\n\n";

        wp_mail( 'jonk@followmedarling.se', $subject, $message );
		/*
			$url     = 'https://graph.facebook.com/v16.0/292723408212991/product_sets';
	$headers = [
		'Content-Type' => 'multipart/form-data',
	];

	$data = [
		'name'     => 'Best Sellers',
		'metadata' => [
			'cover_image_url' => 'https://babaa.es/wp-content/uploads/2022/02/leggings-woman-no49-black-5.jpg',
			'external_url'    => 'https://babaa.es/shop/women/leggings/leggings-no49-black/',
			'description'     => 'yada yada',
		],
	];

	$response   = wp_remote_post(
		$url,
		[
			'method'      => 'POST',
			'timeout'     => 45,
			'redirection' => 5,
			'blocking'    => true,
			'headers'     => $headers,
			'body'        => wp_json_encode( $data ),
		]
	);

	if ( is_wp_error( $response ) ) {
		$success = false;
		$message = $response->get_error_message();
	} else {
		if ( 200 == $response['response']['code'] ) {

		}

	}
		*/
    }

}
