<?php
/*
Template Name: Shop home
*/
?>

<?php

	$page_id = shopkeeper_get_page_id();

    $page_header_src = "";

    if (has_post_thumbnail()) $page_header_src = wp_get_attachment_url( get_post_thumbnail_id( $page_id ) );

	if (get_post_meta( $page_id, 'page_title_meta_box_check', true )) {
		$page_title_option = get_post_meta( $page_id, 'page_title_meta_box_check', true );
	} else {
		$page_title_option = "on";
	}
    

    add_filter( 'body_class','page_sale_body_class' );
    function page_sale_body_class( $classes ) {
        $classes[] = 'woocommerce';
        return $classes;
    }

?>

<?php get_header('shop');

$paged = ( get_query_var('paged') ) ? get_query_var('paged') : 1;
$args = array(
    'post_type' => array( 'product' ), // , 'product_variation' shows all variations in loop, also does not appear in filter
    'posts_per_page' => 32,
    'paged' => $paged,
    'meta_query' => array(
        'relation' => 'AND',
        array(
            'relation' => 'OR',
            array( // Simple products type
                'key' => '_sale_price',
                'value' => 0,
                'compare' => '>',
                'type' => 'numeric'
            ),
            array( // Variable products type
                'key' => '_min_variation_sale_price',
                'value' => 0,
                'compare' => '>',
                'type' => 'numeric'
            )
        ),
        array(
            array(
                'key' => '_stock_status',
                'value' => 'instock',
                'compare' => '=',
            ),
        )
    )
);
$wc_query = new WP_Query( $args );
$wp_query = null;
$wp_query = $wc_query;
?>

	<div class="full-width-page <?php echo ( (isset($page_title_option)) && ($page_title_option == "on") ) ? 'page-title-shown':'page-title-hidden';?>">

        <div class="left-column-widgets off-canvas position-left shop-has-sidebar is-closed" id="offCanvasLeft1" id="offCanvasLeft1" data-off-canvas="" aria-hidden="false" data-e="8siunu-e">
            <div class="menu-close">
                <button class="close-button" aria-label="Close menu" type="button" data-close="">
                    <span aria-hidden="true">×</span>
                </button>
            </div>
            <div class="offcanvas_content_left wpb_widgetised_column">
                <div id="filters-offcanvas">
                    <?php if ( is_active_sidebar( 'shop-sale' ) ) : ?>
                        <?php dynamic_sidebar( 'shop-sale' ); ?>
                    <?php endif; ?>
                </div>
            </div>
        </div>
        <div class="js-off-canvas-overlay is-overlay-fixed is-closable"></div>

        <div id="primary" class="content-area">

            <div id="content" class="site-content" role="main">
                
                <div id="button_offcanvas_sidebar_left" data-toggle="offCanvasLeft1" aria-expanded="false" aria-controls="offCanvasLeft1">
                    <span class="filters-text">
                        <i class="spk-icon spk-icon-menu-filters"></i>
                        Explore</span>
                </div>

                <header class="entry-header <?php if ($page_header_src != "") : ?>with_featured_img<?php endif; ?>" <?php if ($page_header_src != "") : ?>style="background-image:url(<?php echo esc_url($page_header_src); ?>)"<?php endif; ?>>

                    <div class="page_header_overlay"></div>

                    <div class="row">
                        <div class="large-12 columns">

                            <?php if ( (isset($page_title_option)) && ($page_title_option == "on") ) : ?>
                            <h1 class="page-title"><?php the_title(); ?></h1>
                            <?php endif; ?>

                            <?php if($post->post_excerpt) : ?>
                                <div class="page-description"><?php the_excerpt(); ?></div>
                            <?php endif; ?>

                        </div>
                    </div>

                </header><!-- .entry-header -->

                <div class="before_main_content">
                    <?php
                    /**
                    * Hook: woocommerce_before_main_content.
                    *
                    * @hooked WC_Structured_Data::generate_website_data() - 30
                    */
                    do_action( 'woocommerce_before_main_content');
                    ?>
                </div>

                <?php //while ( have_posts() ) : the_post(); ?>

                    <div class="entry-content">
                        <?php //the_content(); ?>

                        <div class="large-12 mobile-columns-<?php echo Shopkeeper_Opt::getOption( 'mobile_columns', 2 ); ?> " id="sale-products">
                            <?php
                                if ( $wc_query->have_posts() ) {
                                    woocommerce_product_loop_start();
                                    while ( $wc_query->have_posts() ) : $wc_query->the_post();
                                        //the_post();
                                        /**
                                         * Hook: woocommerce_shop_loop.
                                         */
                                        do_action( 'woocommerce_shop_loop' );
                                        wc_get_template_part( 'content', 'product' );
                                    endwhile;
                                    woocommerce_product_loop_end();
                                } else {
                                    ?>
                                    <div class="no-products-info">
                                        <p class="woocommerce-no-products">
                                            <?php esc_html_e( 'No products were found matching your selection.', 'woocommerce' ); ?>
                                        </p>
                                    </div>
                                    <?php
                                }
                                wp_reset_postdata(); 
                            ?>
                        </div>

                        <div class="woocommerce-after-shop-loop-wrapper">
                            <?php
                            /**
                             * Hook: woocommerce_after_shop_loop.
                             *
                             * @hooked woocommerce_pagination - 10
                             */
                            do_action( 'woocommerce_after_shop_loop' );
                            //woocommerce_pagination();
                            /*
                            $args = array(
                                'prev_text' => esc_html__( 'Next page', 'bsc' ),
                                'next_text' => esc_html__( 'Previous page', 'bsc' )
                            );
                            */
                            //echo the_posts_navigation( $args );
                            babaa_pagination();
                            wp_reset_query(); 
                            ?>
                        </div>

                    </div><!-- .entry-content -->

                <?php //endwhile; // end of the loop. ?>

                <?php
                /**
                 * Hook: woocommerce_after_main_content.
                 *
                 * @hooked woocommerce_output_content_wrapper_end - 10 (outputs closing divs for the content)
                 */
                do_action('woocommerce_after_main_content');
                ?>

            </div><!-- #content -->

        </div><!-- #primary -->

    </div><!-- .full-width-page -->

<?php get_footer('shop'); 
