<?php
// Customizer
function babaa_customize_register( $wp_customize ) {

    /* Home page for shop */
	$wp_customize->add_section( 'home_page_for_shop', array(
	    'title'          => esc_attr__( 'Home page for shop', 'shopkeeper' ),
	    'priority'       => 10,
	    'capability'     => 'edit_theme_options',
	    'panel'			 => 'panel_shop'
	) );

	/* Home page for shop link */
    $wp_customize->add_setting( 'home_page_for_shop_link' );
	$wp_customize->add_control( 'home_page_for_shop_link', array(
		'type' => 'dropdown-pages',
		'priority' => 11, // Within the section.
		'section' => 'home_page_for_shop', // Required, core or custom.
		'label' => __( 'Link', 'bsc' ),
		'description' => __( 'This is the page that is shown when a user clicks \'home\' in the breadcrumb.', 'bsc' ),
	) );

	/* Fallback images */
    $wp_customize->add_section( 'fallback_images', array(
        'title' => __( 'Fallback images', 'bsc' ),
        'description' => __( 'Fallback images', 'bsc' ),
        'priority' => 150,
    ) );

	/* Fallback OG image */
    $wp_customize->add_setting( 'fallback_og_image' );
    $wp_customize->add_control( new WP_Customize_Image_Control( 
        $wp_customize, 
        'fallback_og_image_control', 
        array(
            'label'             => __( 'Fallback OG image', 'bsc' ),
            'description'       => __( 'This is the image that is shown when a page or post is shared on social media if your page or post doesn\'t have an OG Image. Must be at least 1200 pixels wide and 630 pixels high. Use only jpg or png.' , 'bsc' ),
            'section'           => 'fallback_images',
            'settings'          => 'fallback_og_image', 
            'priority'          => 10,
        )
    )); 

}
add_action( 'customize_register', 'babaa_customize_register', 11 );
