<?php
// General

// Hide Admin Bar
add_action('after_setup_theme', 'babaa_remove_admin_bar');
function babaa_remove_admin_bar() {
    if ( !current_user_can( 'manage_options' ) && !is_admin() ) {
        add_filter( 'show_admin_bar', '__return_false' );
    }
}

// Pagination
function babaa_pagination($args = [], $class = 'pagination') {

    if ($GLOBALS['wp_query']->max_num_pages <= 1) return;

    $args = wp_parse_args( $args, [
        'mid_size'           => 3,
        'end_size'           => 3,
        'prev_next'          => true,
        'prev_text'          => '&larr;',
        'next_text'          => '&rarr;',
        'type'              => 'list',
    ]);

    $links     = paginate_links($args);
    $next_link = get_previous_posts_link($args['next_text']);
    $prev_link = get_next_posts_link($args['prev_text']);
    $template  = apply_filters( 'babaa_pagination_markup_template', '
    <nav class="woocommerce-pagination">
        %4$s
    </nav>', $args, $class);

    echo sprintf($template, $class, $args['screen_reader_text'], $prev_link, $links, $next_link);

}
